<?php
if ($vbulletin->options['dbtech_vbsecurity_active'] AND class_exists('VBSECURITY'))
{
	// parse the config file
	$config = array();
	include(DIR . '/includes/config.php');

	$differences = array();
	foreach ($config as $key => $arr)
	{
		$diff = array_diff((array)$arr, (array)$vbulletin->config[$key]);
		$diff2 = array_diff((array)$vbulletin->config[$key], (array)$arr);

		foreach ((array)$diff as $key2 => $difference)
		{
			$old = var_export($arr[$key2], true);
			$new = var_export($vbulletin->config[$key][$key2], true);

			// Print the difference
			$differences[] = '<li>' . ($old != 'NULL' ? construct_phrase($vbphrase['dbtech_vbsecurity_x_y_changed'], $key, $key2, $old, $new) : construct_phrase($vbphrase['dbtech_vbsecurity_x_y_new'], $key, $key2, $new)) . '</li>';
		}

		foreach ((array)$diff2 as $key2 => $difference)
		{
			$old = var_export($arr[$key2], true);
			$new = var_export($vbulletin->config[$key][$key2], true);

			// Print the difference
			$differences[] = '<li>' . ($old != 'NULL' ? construct_phrase($vbphrase['dbtech_vbsecurity_x_y_changed'], $key, $key2, $old, $new) : construct_phrase($vbphrase['dbtech_vbsecurity_x_y_new'], $key, $key2, $new)) . '</li>';
		}
	}

	$differences = implode("\n", $differences);
	if ($differences AND $differences != VBSECURITY::$cache['watchers']['configtamper'])
	{
		foreach ((array)VBSECURITY::$cache['actions']['configtamper'] as $ruleid => $rules)
		{
			// Perform actions
			if ((int)$rules['actions'] & 1)
			{
				// Close forum
				require_once(DIR . '/includes/adminfunctions.php');
				require_once(DIR . '/includes/adminfunctions_options.php');
				save_settings(array(
					'bbactive' => 0,
					'bbclosedreason' => $vbulletin->options['dbtech_vbsecurity_breach_closedreason']
				));
			}

			if ((int)$rules['actions'] & 2)
			{
				// Email webmaster
				vbmail($vbulletin->options['webmasteremail'], construct_phrase($vbphrase['dbtech_vbmail_security_alert_title'],
					$vbphrase['dbtech_vbsecurity_watcher_configtamper']
				), construct_phrase($vbphrase['dbtech_vbmail_security_alert_body'],
					$vbphrase['dbtech_vbsecurity_watcher_configtamper'],
					strip_tags($differences),
					$vbulletin->options['bburl'],
					$vbulletin->config['Misc']['admincpdir'],
					'general'
				), true);
			}
		}

		// Update this array
		VBSECURITY::$cache['watchers']['configtamper'] = $differences;

		// Store data in the datastore (xD)
		build_datastore('dbtech_vbsecurity_watchers', trim(serialize(VBSECURITY::$cache['watchers'])), 1);
	}
}
?>